PY3_LIBRARY()

OWNER(g:tools-abc)

PEERDIR(
    contrib/python/fastapi
    contrib/python/hypercorn
    contrib/python/ipython
    contrib/python/fastapi-utils
    contrib/python/sqlalchemy/sqlalchemy-1.4
    contrib/python/celery/py2
    contrib/python/boto3
    contrib/python/python-telegram-bot

    library/python/asgi_yauth
    library/python/pyscopg2
    library/python/ylock
    library/python/ylog

    yql/library/python
    kikimr/public/sdk/python/persqueue

)

NO_CHECK_IMPORTS(
    hypercorn.*
    pyscopg2.*
)

PY_SRCS(
    TOP_LEVEL
    watcher/api/routes/abc_migration.py
    watcher/api/routes/base.py
    watcher/api/routes/composition.py
    watcher/api/routes/service.py
    watcher/api/routes/interval.py
    watcher/api/routes/problem.py
    watcher/api/routes/schedule.py
    watcher/api/routes/schedulegroup.py
    watcher/api/routes/shift.py
    watcher/api/routes/slot.py
    watcher/api/routes/subshifts.py
    watcher/api/routes/revision.py
    watcher/api/routes/gap_settings.py
    watcher/api/routes/manual_gap.py
    watcher/api/routes/unistat.py
    watcher/api/schemas/abc_migration.py
    watcher/api/schemas/base.py
    watcher/api/schemas/composition.py
    watcher/api/schemas/interval.py
    watcher/api/schemas/problem.py
    watcher/api/schemas/role.py
    watcher/api/schemas/schedule.py
    watcher/api/schemas/schedulegroup.py
    watcher/api/schemas/scope.py
    watcher/api/schemas/shift.py
    watcher/api/schemas/slot.py
    watcher/api/schemas/staff.py
    watcher/api/schemas/revision.py
    watcher/api/schemas/service.py
    watcher/api/schemas/gap_settings.py
    watcher/api/schemas/manual_gap.py
    watcher/api/schemas/unistat.py
    watcher/app.py
    watcher/bot/core.py
    watcher/celery_app.py
    watcher/common_routes.py
    watcher/config/__init__.py
    watcher/config/celery_beat.py
    watcher/config/default.py
    watcher/config/development.py
    watcher/config/duty_constants.py
    watcher/config/production.py
    watcher/config/testing.py
    watcher/crud/base.py
    watcher/crud/event.py
    watcher/crud/permissions.py
    watcher/crud/holiday.py
    watcher/crud/member.py
    watcher/crud/interval.py
    watcher/crud/revision.py
    watcher/crud/notification.py
    watcher/crud/schedule.py
    watcher/crud/schedule_group.py
    watcher/crud/service.py
    watcher/crud/role.py
    watcher/crud/rating.py
    watcher/crud/shift.py
    watcher/crud/staff.py
    watcher/crud/slot.py
    watcher/crud/composition.py
    watcher/crud/robot.py
    watcher/crud/problem.py
    watcher/crud/bot_user.py
    watcher/crud/gap.py
    watcher/crud/manual_gap.py
    watcher/db/__init__.py
    watcher/db/abc_migration.py
    watcher/db/base.py
    watcher/db/composition.py
    watcher/db/notification.py
    watcher/db/bot_user.py
    watcher/db/from_transfer.py
    watcher/db/interval.py
    watcher/db/schedule.py
    watcher/db/rating.py
    watcher/db/shift.py
    watcher/db/problem.py
    watcher/db/event.py
    watcher/db/manual_gap.py
    watcher/db/unistat.py
    watcher/enums.py
    watcher/logging.py
    watcher/manage.py
    watcher/logic/clients/base.py
    watcher/logic/clients/abc.py
    watcher/logic/clients/staff.py
    watcher/logic/clients/staff_api.py
    watcher/logic/clients/jns.py
    watcher/logic/notification.py
    watcher/logic/logger/base.py
    watcher/logic/logger/http.py
    watcher/logic/logger/httptracking.py
    watcher/logic/logger/celery.py
    watcher/logic/logger/sqltracking.py
    watcher/logic/logger/state.py
    watcher/logic/logger/profiler.py
    watcher/logic/logger/provider/auth.py
    watcher/logic/logger/provider/base.py
    watcher/logic/logger/provider/request.py
    watcher/logic/auth.py
    watcher/logic/boundaries_revision.py
    watcher/logic/common.py
    watcher/logic/composition.py
    watcher/logic/exception_handler.py
    watcher/logic/exceptions.py
    watcher/logic/filter.py
    watcher/logic/fields.py
    watcher/logic/manual_gap.py
    watcher/logic/holidays.py
    watcher/logic/interval.py
    watcher/logic/locks.py
    watcher/logic/logbroker.py
    watcher/logic/member.py
    watcher/logic/order.py
    watcher/logic/pagination.py
    watcher/logic/people_allocation.py
    watcher/logic/permissions.py
    watcher/logic/problem.py
    watcher/logic/rating.py
    watcher/logic/revision.py
    watcher/logic/schedule.py
    watcher/logic/schedule_group.py
    watcher/logic/shift.py
    watcher/logic/service.py
    watcher/logic/slot.py
    watcher/logic/staff.py
    watcher/logic/timezone.py
    watcher/logic/tvm_client.py
    watcher/tasks/__init__.py
    watcher/tasks/abc_migration.py
    watcher/tasks/base.py
    watcher/tasks/bot.py
    watcher/tasks/composition.py
    watcher/tasks/group.py
    watcher/tasks/statistics.py
    watcher/tasks/sync.py
    watcher/tasks/task_queue.py
    watcher/tasks/generating_shifts.py
    watcher/tasks/people_allocation.py
    watcher/tasks/shift.py
    watcher/tasks/problem.py
    watcher/tasks/notification.py
    watcher/tasks/event_processing.py
    watcher/tasks/process_delete_members.py
    watcher/tasks/rating.py
    watcher/tasks/manual_gap.py
    watcher/tasks/schedule.py
    watcher/tasks/unistat.py
    watcher/middleware.py
    watcher/router.py
)

END()
