from watcher.db.schedule import SchedulesGroup
from watcher.tasks.group import delete_autogenerated_groups_without_schedule


def test_delete_autogenerated_groups_without_schedule(schedule_factory, schedules_group_factory, scope_session):
    groups_to_delete = [schedules_group_factory(autogenerated=True) for _ in range(5)]
    groups_to_remain = [
        schedules_group_factory(autogenerated=True),
        schedules_group_factory(autogenerated=True),
        schedules_group_factory(),
        schedules_group_factory(),
    ]
    group_ids = [group.id for group in groups_to_remain + groups_to_delete]

    for group in groups_to_remain:
        if group.autogenerated:
            schedule_factory(schedules_group=group)

    delete_autogenerated_groups_without_schedule.apply()

    remain_groups = scope_session.query(SchedulesGroup).filter(SchedulesGroup.id.in_(group_ids)).all()
    assert len(remain_groups) == len(groups_to_remain)
    assert {group.id for group in remain_groups} == {group.id for group in groups_to_remain}
