# coding: utf-8

from datetime import datetime, timedelta


class CacheClient(object):
    def __init__(self):
        self._cached_objects = {}

    def get(self, key, default=None):
        if key not in self._cached_objects.keys():
            return default
        else:
            value, expired_at = self._cached_objects[key]
            if expired_at is None or expired_at > datetime.now():
                return value
            else:
                return default

    def set(self, key, value, expiration_time=None):
        if expiration_time is None:
            self._cached_objects[key] = (value, None)
        else:
            self._cached_objects[key] = (value, datetime.now() + timedelta(seconds=expiration_time))
