# coding: utf-8

from __future__ import unicode_literals

from fabric.api import local, task
from gitchronicler import chronicler


conf = {
    'project': 'registry.yandex.net/tools/webauth',
}


@task
def dc(cmd):
    local('docker-compose %s' % cmd)


@task
def build(push=False):
    conf['version'] = _get_version()

    dc('build webauth')
    if push:
        local('docker tag {project}:latest {project}:{version}'.format(**conf))
        local('docker push {project}:latest'.format(**conf))
        local('docker push {project}:{version}'.format(**conf))


@task
def deploy(qloud_env='testing'):
    build(push=True)
    conf['qloud_env'] = qloud_env
    conf['components'] = 'app'

    local(
        'releaser deploy -v %(version)s -e %(qloud_env)s -c %(components)s '
        '--deploy-comment-format "releasing version %(version)s"' % conf
    )


@task
def release():
    local('git checkout master')
    local('git pull origin master')
    local('git fetch --tags')
    local('releaser changelog')
    local('releaser vcs_commit')
    local('releaser vcs_tag')
    local('releaser vcs_push')


@task
def test():
    dc('build tests_webauth')
    dc('run tests_webauth /app/.venv/old_bin/py.test -vvvv /app/webauth/tests_webauth/')


def _get_version():
    last_release_version = chronicler.get_current_version()
    commits_after_release = local(
        'git log --no-merges --format=%s {0}..HEAD | wc -l'.format(last_release_version),
        capture=True
    )
    return '%s.%s' % (last_release_version, commits_after_release)
