# encoding: utf-8
from __future__ import unicode_literals

import abc
import httplib

import tornado.web
from tornado import gen


class BaseMonitoringHandler(tornado.web.RequestHandler):
    __metaclass__ = abc.ABCMeta

    @abc.abstractmethod
    def monitoring(self):
        return []

    @gen.coroutine
    def get(self):
        status_code = httplib.OK
        response = 'OK'

        errors = yield self.monitoring()
        if errors:
            if isinstance(errors, basestring):
                errors = [errors]
            status_code = httplib.INTERNAL_SERVER_ERROR
            response = ' | '.join(errors)

        self.set_status(status_code)
        self.finish(response)
