# coding: utf-8
from __future__ import unicode_literals

import os
import time

from tornado import gen

from intranet.webauth.lib.monitorings.base import BaseMonitoringHandler
from intranet.webauth.lib.settings import (
    WEBAUTH_QLOUD_SYNC_MARK_FILE,
    WEBAUTH_QLOUD_SYNC_AGE,
)


class CheckQloudSyncHandler(BaseMonitoringHandler):
    @gen.coroutine
    def monitoring(self):
        if not os.path.exists(WEBAUTH_QLOUD_SYNC_MARK_FILE):
            raise gen.Return('Qloud sync file does not exist')

        sync_age = time.time() - os.path.getmtime(WEBAUTH_QLOUD_SYNC_MARK_FILE)
        if sync_age > WEBAUTH_QLOUD_SYNC_AGE:
            hours = round(sync_age / 3600, 1)
            raise gen.Return('Sync with qloud succeeded {} hours ago'.format(hours))

        raise gen.Return(None)
