# encoding: utf-8
from __future__ import unicode_literals

import base64
import os

WEBAUTH_DEBUG = os.getenv('VIEWER_DEBUG', '0') == '1'
DEV_PATH_PREFIX = '/tmp/development/'
YENV_TYPE = os.getenv('YENV_TYPE')

if YENV_TYPE == 'development':
    WEBAUTH_IDM_CACHE_FOLDER = '{}cached-systems'.format(DEV_PATH_PREFIX)
    WEBAUTH_QLOUD_SYNC_MARK_FILE = '{}qloud-sync-mark'.format(DEV_PATH_PREFIX)
else:
    WEBAUTH_IDM_CACHE_FOLDER = '/ephemeral/cached-systems'
    WEBAUTH_QLOUD_SYNC_MARK_FILE = '/ephemeral/qloud-sync-mark'

WEBAUTH_USE_MDS = os.getenv('WEBAUTH_USE_MDS', '0') == '1'
WEBAUTH_ACCESS_KEY_ID = os.getenv('WEBAUTH_ACCESS_KEY_ID')
WEBAUTH_SECRET_ACCESS_KEY = os.getenv('WEBAUTH_SECRET_ACCESS_KEY')

WEBAUTH_IDM_CHECK_PERIOD = 5 * 60  # every 5 minutes tornado server will reload .json files which contain IDM data
WEBAUTH_IDM_PAGE_SIZE = int(os.getenv('WEBAUTH_IDM_PAGE_SIZE', '250'))
WEBAUTH_IDM_HOST = "idm-api.yandex-team.ru" if not WEBAUTH_DEBUG else "idm-api.test.yandex-team.ru"
WEBAUTH_IDM_CACHE_TTL_FOR_MONITORING = 2 * 60 * 60  # cache ttl for monitorings - 2 hours

WEBAUTH_OAUTH_TOKEN = os.getenv('VIEWER_OAUTH_TOKEN')
WEBAUTH_TORNADO_WORKERS = int(os.getenv('WEBAUTH_TORNADO_WORKERS', '1'))

WEBAUTH_VIEWER_HOSTS_IDM_SUFFIXES = ['.v.yandex-team.ru', '.viewer.yandex-team.ru']
WEBAUTH_YANDEX_CERT_DOMAINS = ["ld.yandex.ru"]
WEBAUTH_YANDEX_CERT_ISSUERS = ["YandexInternalCA"]  # actually, it seems to be the only possible issuer

if YENV_TYPE in ['development', 'testing']:
    WEBAUTH_YANDEX_CERT_ISSUERS += ['InternalTestCA', 'Test-YandexInternal-Ca']

WEBAUTH_CLIENT_TOKEN_COOKIE = "webauth_oauth_token"
WEBAUTH_CSRF_TOKEN_COOKIE = "webauth_csrf_token"
WEBAUTH_OAUTH_APPLICATION_ID = os.getenv('WEBAUTH_OAUTH_APPLICATION_ID')
WEBAUTH_OAUTH_APPLICATION_SECRET = os.getenv('WEBAUTH_OAUTH_APPLICATION_SECRET')
WEBAUTH_OAUTH_SCOPE = 'webauth:authenticate'

WEBAUTH_CRYPTOGRAPHY_KEY = base64.b64decode(os.getenv('WEBAUTH_CRYPTOGRAPHY_KEY'))

BYPASS_NETS = ['_SKYNETCLIENTS_', '_DYNAMICACCESSNETS_', '_UNIFIEDUSERNETS_']
BYPASS_HOSTS = ['passport-test.yandex.ru', 'pass-test.yandex.ru', 'social-test.yandex.ru', 'oauth-test.yandex.ru',
                'passport-test.yandex.com', 'pass-test.yandex.com', 'social-test.yandex.com', 'oauth-test.yandex.com']
WEBAUTH_NETWORK_WHITELISTS = {k: BYPASS_NETS for k in BYPASS_HOSTS}

WEBAUTH_QLOUD_CHECK_PERIOD = 2 * 60  # 2 minutes
WEBAUTH_QLOUD_SYNC_AGE = 2 * 60 * 60  # 2 hours

WEBAUTH_YT_OAUTH_TOKEN = os.getenv('WEBAUTH_YT_OAUTH_TOKEN')
WEBAUTH_YLOCK_CONFIG = {
    'backend': 'yt',
    'prefix': '//home/webauth/{}'.format(os.getenv('YENV_TYPE')),
    'token': WEBAUTH_YT_OAUTH_TOKEN,
    'connect_timeout': 3,
}

WEBAUTH_STAFF_API_HOST = 'staff-api.yandex-team.ru'

WEBAUTH_ROOT_CERT_LOCATION = '/etc/ssl/certs/YandexInternalRootCA.pem'

# Отладочные настройки для переезда в Deploy
WEBAUTH_HTTP_CLIENT_VALIDATE_SSL = bool(int(os.getenv('WEBAUTH_HTTP_CLIENT_VALIDATE_SSL', 0)))

WEBAUTH_REDIS_HOST = '127.0.0.1'
WEBAUTH_REDIS_PORT = 6379
WEBAUTH_REDIS_POOL_SIZE = 300
WEBAUTH_REDIS_CONNECT_TIMEOUT = 1
WEBAUTH_REDIS_READ_TIMEOUT = 1

WEBAUTH_STATFACE_TOKEN = os.getenv('WEBAUTH_STATFACE_TOKEN')
WEBAUTH_YQL_TOKEN = os.getenv('WEBAUTH_YQL_TOKEN')

WEBAUTH_USER_CREDENTIALS_CACHE_TTL = 120  # 2 minutes, b/c user ticket lives 5min

WEBAUTH_HTTP_POOL_SIZE = int(os.getenv('WEBAUTH_HTTP_POOL_SIZE', '500'))

YAUTH_AVAILABLE_TLDS = [
    'az', 'by', 'com',
    'co.il', 'com.am', 'com.ge', 'com.tr',
    'ee', 'fr', 'kg', 'kz', 'lt', 'lv',
    'md', 'ru', 'tj', 'tm', 'ua', 'uz',
]

CROWDTEST_ZONE_PATTERN = r'(^|\.)crowdtest\.(yandex|yandex-team)\.({})$'.format(
    '|'.join([tld.replace('.', r'\.') for tld in YAUTH_AVAILABLE_TLDS]))
