# coding: utf-8

from __future__ import with_statement, unicode_literals
from os import path
from os import makedirs
import os
import re

from invoke import task, run


def find_manage_py():
    return './usr/local/bin/wiki'


@task
def collect_static(c):
    """
    Собирает статику джанго-приложений в папку STATIC_ROOT.
    """
    run(wiki_manage() + ' collectstatic -v0 --noinput --settings=wiki.build_package_settings')


def ensure_locale_dirs():
    """
    Создать все необходимые папки с локалями если еще не.
    """
    for lang in ('en', 'ru'):
        locale_path = 'locale/{0}/LC_MESSAGES'.format(lang)
        # print 'the locale path', path.abspath(locale_path)
        if not path.exists(locale_path):
            makedirs(locale_path)
        run('touch {0}/django.po'.format(locale_path))


def local_manage_command(command):
    return run(wiki_manage() + ' ' + command)


@task
def download_from_tanker(c, branch_name=None):
    """
    Скачать переводы из танкера.

    """
    ensure_locale_dirs()
    command = 'tankerdownload -v0 --settings=wiki.build_package_settings'
    if branch_name:
        command += ' --branch=' + branch_name
    local_manage_command(command)


@task
def update_local_tanker_pos(c):
    """
    Скачать актуальные строки из танкера и обновить их строками из проекта.
    """
    local_manage_command(
        ' makemessages --no-obsolete -d django -a -ifrontend/* -ihtdocs/* -idebian/* '
        ' -iphp/* -ilocale/* -ilog/* -isearch/* -ivar/* -i*/.robe/* -v0 '
        ' --settings=wiki.build_package_settings'
    )


@task
def upload_to_tanker(c, branch_name):
    """
    Закачать переводы в указанную ветку
    """
    local_manage_command((' tankerupload -v0 ' '--settings=wiki.build_package_settings ' '--branch=') + branch_name)


@task
def tanker_ref_for_branch(c, branch_name):
    """
    Создать ветку branch_name в танкере.
    """
    local_manage_command(
        ('tankerputbranch ' '-v0 --settings=wiki.build_package_settings ' '--branch={}').format(branch_name)
    )


@task
def tanker_update_branch_for_stand(c, branch_name):
    """
    Начать в танкере ветку для работы со стендом.

    Загружает переводы из текущей ветки TANKER_REVISION,
    обновляет локальные po-файлы новыми переводами,
    создает в танкере ветку branch_name.
    """
    ensure_locale_dirs()
    tanker_ref_for_branch(c, branch_name)
    download_from_tanker(c, branch_name)
    update_local_tanker_pos(c)
    upload_to_tanker(c, branch_name)
    download_from_tanker(c, branch_name)


def wiki_manage(wiki_code='wiki'):
    return 'wiki_code={0} {1}'.format(wiki_code, find_manage_py())


@task
def manage(c, command='', code='wiki'):
    """
    Call wiki script
    """
    c.run(wiki_manage(code) + ' ' + command)


@task
def compile_messages(c):
    c.run(wiki_manage() + ' compilemessages -v0 --settings=wiki.build_package_settings --locale ru --locale en')


@task
def check_po_files(c):
    c.run(
        (
            'SUPPRESS_DATASOURCES_WARNING=1 wiki_code=wiki {0} '
            ' check_po_files -v2 --settings=wiki.build_package_settings'
        ).format(find_manage_py())
    )
