import os
import sys
import warnings
from io import BytesIO
from .helpers import Hook
import flake8.main.application

ARC_ROOT = os.popen('arc root').read().strip()


class FlakeHook(Hook):
    NAME = 'Flake8 (arc config)'

    @classmethod
    def main(cls, filenames):
        args = ['--config', cls.get_lint_cfg_path(), '--format', 'pylint'] + filenames
        app = flake8.main.application.Application()

        stream_out = BytesIO()
        # hack for flake8 4.0+
        stream_out.buffer = stream_out

        with warnings.catch_warnings():
            warnings.simplefilter('ignore', category=UnicodeWarning)
            sys.stdout = stream_out
            try:
                app._run(args)  # pylint: disable=protected-access
            finally:
                sys.stdout = sys.__stdout__

        if app.result_count:
            errors = stream_out.getvalue()
            print(errors.decode())
        return app.result_count == 0

    @classmethod
    def get_lint_cfg_path(cls):
        path = os.path.join(ARC_ROOT, 'build/config/tests/flake8.conf')
        if os.path.exists(path):
            return path
        return os.path.join(ARC_ROOT, 'build/config/tests/flake8/flake8.conf')
