import re
from io import open

from .helpers import Hook
from ..utils import progress_msg

LOCAL_IMPORT_RE = re.compile(r'^from wiki_tests\.', re.MULTILINE)


def find_autoimports(filename):
    with open(filename, encoding='UTF-8', newline='') as f:
        contents = f.read()
        if LOCAL_IMPORT_RE.findall(contents):
            progress_msg(
                f'File {filename} contains pycharm import relative to src; replace it with absolute '
                'to the root of Arcadia'
            )
            return True
        return False


class FixPycharmAutoimportsHook(Hook):
    NAME = 'Fixing autoimports'

    @classmethod
    def main(cls, files):
        for filename in files:
            if find_autoimports(filename):
                return False

        return True
