import os
import re
from pathlib import Path


def inject():
    global_config = Path.home() / '.arcconfig'
    # default_exec = 'ya tool precommit'
    default_exec = 'intranet/wiki/devtools/precommit/precommit'
    default_name = 'ya_precommit'

    ARC_ROOT = os.popen('arc root').read().strip()
    project = str(Path.cwd()).replace(ARC_ROOT, '')[1:]

    new_config = []
    raw_data = []

    try:
        with global_config.open('r') as f:
            raw_data = f.readlines()
    except FileNotFoundError:
        pass

    IDLE = 0
    CURRENT_PROJECT_SECTION = 1
    CURRENT_PROJECT_PATCHED = 2

    sm = IDLE

    header_re = re.compile(r"\[\s*pre-commit-hook\s*\"(.*?)\"\s*]")
    hook_re = re.compile(r'\s*(.*?)\s*=\s*(.*?)$')

    cfg_header = f'[pre-commit-hook "{project}"]'
    cfg = f'    {default_name} = {default_exec}'

    for line in raw_data:
        line = line.strip('\n')
        match_header = header_re.match(line)
        match_hook = hook_re.match(line)

        if sm == IDLE:
            new_config.append(line)
            if match_header:
                current_section = match_header.group(1)
                if current_section == project:
                    sm = CURRENT_PROJECT_SECTION
                else:
                    sm = IDLE

        elif sm == CURRENT_PROJECT_SECTION:
            if match_header:
                new_config.append(cfg)
                new_config.append(line)
                sm = CURRENT_PROJECT_PATCHED
            elif match_hook:
                if match_hook.group(1) == default_name:
                    new_config.append(cfg)
                    sm = CURRENT_PROJECT_PATCHED
                else:
                    new_config.append(line)
        elif sm == CURRENT_PROJECT_PATCHED:
            new_config.append(line)

    if sm == CURRENT_PROJECT_SECTION:
        new_config.append(cfg)
    elif sm == IDLE:
        new_config.append(cfg_header)
        new_config.append(cfg)

    new_config = '\n'.join(new_config)

    print(new_config)

    with global_config.open('w') as f:
        f.write(new_config)
