from .hooks import BlackHook, FlakeHook, FixStringsHook, Hook, FixPycharmAutoimportsHook
from .utils import header_msg, error_msg


def get_pipeline():
    return [FixPycharmAutoimportsHook, FixStringsHook, BlackHook, FlakeHook]


def run_pipeline(files):
    pipeline = get_pipeline()
    for stage in pipeline:
        stage: Hook
        header_msg(stage.NAME)
        if not stage.main(files):
            error_msg(f'{stage.NAME} failed')
            return False
    return True
