#!/usr/bin/env python3
from .injector import inject
from .utils import get_changed_files, neutral_msg, header_msg
from .pipeline import run_pipeline
import click


@click.group(invoke_without_command=True)
@click.pass_context
def main(ctx):
    if ctx.invoked_subcommand is None:
        run()


@main.command()
def run():
    changed_files = get_changed_files()
    header_msg('Collecting changed files')

    if len(changed_files) == 0:
        neutral_msg('No python files changed. Skipping pipeline')
        return

    neutral_msg(f'{len(changed_files)} python files to process.')

    for changed_file in changed_files:
        neutral_msg(f' - {changed_file}')

    neutral_msg('')
    if not run_pipeline(changed_files):
        exit(-1)


@main.command()
def install():
    neutral_msg('Injecting...')
    inject()
