import os
import sys
from typing import IO

from colorama import Fore, Style


def write(s: str, stream: IO[bytes] = sys.stdout.buffer) -> None:
    stream.write(s.encode())
    stream.flush()


def msg(color, message):
    write(color + message + Style.RESET_ALL)


def neutral_msg(message):
    msg(Fore.RESET, message + '\n')


def progress_msg(message):
    msg(Fore.WHITE, f'  - {message} \n')


def error_msg(message):
    msg(Fore.RED, f'[ERR] {message}\n')


def header_msg(message):
    msg(Fore.RESET, f'{message+" ":.<120}\n')


def ok_msg(message):
    msg(Fore.GREEN, message)


def get_changed_files():
    ARC_ROOT = os.popen('arc root').read().strip()
    changed_files = os.popen('arc diff --name-only  --cached | egrep \'\\.py$\'').read().strip().split('\n')
    abs_changed_files = [os.path.join(ARC_ROOT, file) for file in changed_files]
    return [file for file in abs_changed_files if os.path.isfile(file)]
