#!/bin/bash
TEST_DIR="/intranet/wiki/tests"

MY_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
ARC_ROOT="$(realpath ${MY_DIR}/../../../)"
# use arc root
export Y_PYTHON_SOURCE_ROOT=$ARC_ROOT
export Y_PYTHON_ENTRY_POINT=":main"
export ENVIRONMENT="tests"
export NO_MIGRATE_DB=True
export PYCHARM_TEST_RUN=True
export PYTHONWARNINGS=ignore

export wiki_code=wiki
if [ -f "${MY_DIR}/.env" ]
then
  export $(cat "${MY_DIR}/.env" | sed 's/#.*//g' | xargs)
fi

export DJANGO_SETTINGS_MODULE=wiki.test_settings
export IS_TESTS=1
export ARC=1
export PYTHONPATH="${PYTHONPATH}:${ARC_ROOT}/intranet/wiki/tests:${ARC_ROOT}/intranet/wiki/src"

export PG_LOCAL_DATABASE=wiki
export PG_LOCAL_USER=postgres
export PG_LOCAL_PORT=5433
export PG_LOCAL_PASSWORD=postgres
export RECIPE_MONGO_PORT=27018
export RECIPE_MONGO_HOST=localhost
export REDIS_RECIPE_HOST=localhost
export REDIS_RECIPE_PORT=6380

${ARC_ROOT}/intranet/wiki/test_suites/intranet/run-tests "$@"
