# Anti-corruption layer
# Пока acl не переписан на новый, отсюда ходим в старый или новый механизм
from typing import Generator, List, Any

from wiki.acl.consts import Action
from wiki.api_v2.exceptions import Forbidden
from wiki.pages.access import has_access as _has_access, is_admin
from wiki.pages.models import Page
from wiki.sync.connect.org_ctx import org_ctx
from wiki.sync.connect.base_organization import BaseOrganization
from wiki.pages.access import get_bulk_access_status, ACCESS_COMMON, ACCESS_RESTRICTED, ACCESS_UNLIMITED


def assert_has_access(user, organization: BaseOrganization, page: Page, op: Action, message: str = 'Forbidden'):
    if not _check_access(user, organization, '', page, op):
        raise Forbidden(message)


def has_access(user, organization: BaseOrganization, page: Page, op: Action):
    return _check_access(user, organization, '', page, op)


# Пока существуют пропуски в дереве страниц
# нужна возможность проверки доступа по слагу
# т.к. страницы для него может не существовать
def assert_has_access_by_slug(user, organization, slug: str, op: Action):
    if not _check_access(user, organization, slug, None, op):
        raise Forbidden()


def has_access_by_slug(user, organization, slug: str, op: Action):
    return _check_access(user, organization, slug, None, op)


def _check_access(user, organization, slug, page: Page, op: Action):
    priv = 'read'

    if op == Action.DELETE:  # only authors/owners
        return user in page.get_authors() or is_admin(user)

    if op == Action.CHANGE_AUTHORS:  # only authors/owners, as in authors_logic.can_change_authors(page, user)
        return user in page.get_authors() or is_admin(user)

    if op == Action.CHANGE_ACL:  # only authors/owners, as in AccessView
        return user in page.get_authors() or is_admin(user)

    if op != Action.READ:
        priv = 'write'

    if op != Action.READ and page and page.is_readonly:  # only authors/owners
        return user in page.get_authors() or is_admin(user)

    with org_ctx(organization.as_django_model()):
        return _has_access(slug, user, privilege=priv, current_page=page)


def filter_by_access(pages: List[Page], user, organization: BaseOrganization) -> Generator[Page, Any, None]:
    with org_ctx(organization.as_django_model()):
        access_statuses = get_bulk_access_status(tags=[p.slug for p in pages], user=user)
    valid_access = {ACCESS_COMMON, ACCESS_RESTRICTED, ACCESS_UNLIMITED}
    return (page for page in pages if access_statuses[page.slug] in valid_access)
