import enumfields.fields
from django.db import migrations, models
from django.contrib.postgres.fields import JSONField

import wiki.acl.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('pages', '0022_add_acl_mgmt'),
    ]

    operations = [
        migrations.CreateModel(
            name='Acl',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('page', models.OneToOneField(on_delete=models.CASCADE, to='pages.Page')),
                ('break_inheritance', models.BooleanField()),
                ('acl', JSONField(null=True)),
                (
                    'parent_acl',
                    models.ForeignKey(null=True, on_delete=models.CASCADE, to='acl.Acl', related_name='parent'),
                ),
                ('parent_acl_type', enumfields.fields.EnumField(enum=wiki.acl.consts.ParentAclType, max_length=1)),
            ],
        ),
    ]
