
from enumfields import EnumField

from django.contrib.postgres.fields import JSONField
from django.db import models

from wiki.acl.consts import ParentAclType, AclDiff
from wiki.pages.models import Page


class Acl(models.Model):

    page = models.OneToOneField(to=Page, on_delete=models.CASCADE)

    break_inheritance = models.BooleanField()

    acl = JSONField(null=True, blank=True)

    parent_acl = models.ForeignKey('self', null=True, blank=True, related_name='parent', on_delete=models.CASCADE)

    parent_acl_type = EnumField(ParentAclType)

    def copy(self):
        return Acl(
            page=self.page,
            break_inheritance=self.break_inheritance,
            acl=self.acl,
            parent_acl=self.parent_acl,
            parent_acl_type=self.parent_acl_type,
        )

    def __str__(self):
        return (
            f'id={self.id} page={self.page} break_inheritance={self.break_inheritance} parent_acl={self.parent_acl} '
            f'parent_acl_type={self.parent_acl_type} acl={self.acl} '
        )

    def __eq__(self, other):
        return (
            isinstance(other, Acl)
            and self.page == other.page
            and self.break_inheritance == other.break_inheritance
            and AclDiff.parse_raw(self.acl) == AclDiff.parse_raw(other.acl)
            and self.parent_acl == other.parent_acl
            and self.parent_acl_type == other.parent_acl_type
        )

    class Meta:
        app_label = 'acl'
