
import io

import xlwt

from wiki.actions.classes.form_elements.submit_handlers.mail import EmailSubmitHandler


class ExcelSubmitter(EmailSubmitHandler):
    """
    Создать из формы документ Excel и отправить его почте
    """

    def _form_as_list(self):
        """
        Возвращает представление формы в виде списка
        """
        template = self.template.split(';')
        if not template:
            template = [f['name'] for f in self.form.for_handler()]
            template.append('%staff%')
        result = []
        for entity in template:
            result.append(self.process(entity))
        return result

    def xls(self):
        """
        Предполагаем, что вы в шаблоне указали поля формы, разделенные ";"
        """
        wb = xlwt.Workbook()
        ws = wb.add_sheet('Данные формы' + (' ' + self.form.form_title if self.form.form_title else ''))
        print_fields = self._form_as_list()
        for i in range(len(print_fields)):
            ws.write(0, i, print_fields[i])
        xls = io.StringIO()
        wb.save(xls)
        return self._create_attachment('form.xls', xls.getvalue(), 'application/xls')

    def _attach_files(self):
        attachments = super(ExcelSubmitter, self)._attach_files()
        attachments.append(self.xls())
        return attachments
