
import urllib.error
import urllib.parse
import urllib.request
from urllib.error import HTTPError

from django.utils.translation import ugettext

from wiki.actions.classes.form_elements.form_errors import FormHandlingError
from wiki.actions.classes.form_elements.submit_handlers.base import SubmitHandler
from wiki.actions.classes.form_elements.submit_handlers.urllib2_file import newHTTPHandler

opener = urllib.request.build_opener(newHTTPHandler)


class HttpSubmitHandler(SubmitHandler):
    """
    Отправка данных формы через HTTP POST запросом
    """

    def __init__(self, form, **kwargs):
        super(HttpSubmitHandler, self).__init__(form, **kwargs)
        self.all_files = {}

    def handle(self, target):
        """
        Собрать все поля и послать их по HTTP POST запросом

        @see: https://st.yandex-team.ru/browse/WIKI-1541
        """
        super(HttpSubmitHandler, self).handle(target)
        fields = self.form.for_handler()
        data = {}
        for item in fields:
            name, v = item['name'], item['value']
            if v is not None:
                data[name] = v

        for name, tmp_file_obj in self.form.files.items():
            data[name] = {'fd': tmp_file_obj.file, 'filename': tmp_file_obj.name}

        if isinstance(target.to, urllib.parse.ParseResult):
            urls = [target.to]
        else:
            urls = target.to

        for url in urls:
            # Этот код может удивить, но, по-видимому, имелось в виду то,
            # что можно написать урл с указанием кодировки в виде
            # `http://cp-1251:@something.yandex-team.ru/blabla` и тогда
            # в параметре `username` будет нужная кодировка. Возможно,
            # об этом синтаксисе никто и не знает
            encoding = url.username or 'UTF-8'
            destination = url._replace(netloc=url.hostname).geturl()
            try:
                opener.open(destination, self._enc(encoding, data))
            except HTTPError as inst:
                raise FormHandlingError(
                    FormHandlingError.CODES.GENERIC,
                    message=' '.join((ugettext('HTTP error while submitting form') + ':', str(inst.code), inst.msg)),
                )

    def _enc(self, encoding, data):
        """
        Encode array of data to send by POST
        """
        send = data.copy()
        for k, v in send.items():
            if isinstance(v, dict) and 'filename' in v:
                send[k]['filename'] = v['filename'].encode(encoding)
            else:
                if not isinstance(v, str):
                    v = str(v)
                send[k] = v.encode(encoding)
        return send
