
import logging

logger = logging.getLogger(__name__)


def get_startrek_field_type(startrek_field):
    startrek_schema = startrek_field['schema']
    if startrek_schema['type'] == 'array':
        field_type = 'array/' + startrek_schema['items']
    else:
        field_type = startrek_schema['type']
    return field_type


def get_form_field_type(form_field):
    field_type = form_field.field_type
    if getattr(form_field, 'multiple', False):
        field_type += '/multiple'
    return field_type


def stringify_startrek_errors(startrek_errors):
    error_messages = ', '.join(startrek_errors.get('errorMessages', []))
    error_data_string = ', '.join(
        ['%s: %s' % (key, value) for key, value in list(startrek_errors.get('errors', {}).items())]
    )
    error_string = '. '.join([string for string in (error_messages, error_data_string) if string])
    return error_string


STARTREK_FIELD_TYPES = {
    'array/component': 'many_integers_or_strings',
    'array/maillist': 'many_strings',
    'array/string': 'many_strings',
    'array/translation': 'many_integers_or_strings',
    'array/user': 'many_users',
    'array/version': 'many_integers',
    'array/service': 'many_services',
    'date': 'date',
    'datetime': None,
    'float': 'float',
    'integer': 'integer',
    'issue': None,
    'money': None,
    'resolution': 'integer_or_string',
    'string': 'string',
    'text': 'text',
    'timetracking': None,
    'translation': 'integer_or_string',
    'user': 'user',
    'issuetype': 'integer_or_string',
    'priority': 'integer_or_string',
    'service': 'service',
}

FORM_FIELD_TYPE_GROUPS = {
    'many_integers_or_strings': [
        'text',
        'string',
        'info',
        'select',
        'number',
    ],
    'many_strings': [
        'text',
        'string',
        'info',
        'select',
    ],
    'many_integers': [
        'string',
        'info',
        'select',
        'number',
    ],
    'many_users': [
        'text',
        'staff/multiple',
        'staff',
        'string',
        'info',
        'select',
    ],
    'many_services': [
        'text',
        'service',
        'string',
        'info',
        'select',
    ],
    'user': [
        'staff',
        'string',
        'info',
        'select',
    ],
    'service': [
        'service',
        'string',
        'info',
        'select',
    ],
    'date': ['date'],
    'float': ['number'],
    'integer': [
        'number',
        'string',
        'info',
        'select',
    ],
    'integer_or_string': [
        'string',
        'info',
        'select',
        'number',
    ],
    'string': [
        'string',
        'info',
        'select',
        'number',
        'staff',
        'group',
        'checkbox',
        'service',
    ],
    'text': [
        'text',
        'string',
        'text',
        'info',
        'select',
        'number',
        'staff',
        'group',
        'checkbox',
        'service',
    ],
}
