"""
Виджеты для отображения полей формы, которые позволяют jQuery использовать валидацию

@author: chapson
@status: Development
@maintainer: Chaporgin Anton
@copyright: 2010, Yandex
@version: 0.0
"""
from django.forms import widgets
from django.utils.safestring import mark_safe


class ClearInput(widgets.Input):
    """
    Widget for all input fields
    """

    pass


class ClearDateInput(widgets.DateInput):
    """
    Виджет для отображения и выбора даты
    """

    pass
    # class Media:
    # js = ('/_js/jquery/jquery.ui.datepicker.js',)


class ClearInformation(widgets.Widget):
    """
    Виджет отображающий значение поля
    """

    pass


class ClearStaffAutocomplete(widgets.Input):
    """
    Виджет отображающий список персонала с автодополнением
    """

    def __init__(self, multiple=False, attrs=None):
        self.multiple = multiple
        super(ClearStaffAutocomplete, self).__init__(attrs)

    def render(self, name, value, attrs=None):
        onclick = {}
        if self.multiple:
            onclick.update({'multiple': 'true', 'multipleSeparator': '","'})
        js_autocomplete = {
            # , 'onclick': 'return {"value":"%s"}' % self.display
            'class': 'js-autocomplete_staff b-autocomplete-input',
            'autocomplete': 'off',
            'onclick': 'return {%s}' % (', '.join(['%s: %s' % el for el in iter(onclick.items())]),),
        }
        final_attrs = self.build_attrs(attrs, type=self.input_type, name=name)
        if 'class' in final_attrs:
            js_autocomplete['class'] = js_autocomplete['class'] + ' ' + final_attrs['class']
        final_attrs.update(js_autocomplete)  # = js_autocomplete if attrs is None else dict(attrs, **js_autocomplete)
        result = '''
<script type="text/javascript" src="//center.yandex-team.ru/media/js/_js-autocomplete_staff.js"></script>
        '''
        return mark_safe(result + super(ClearStaffAutocomplete, self).render(name, value, final_attrs))


class ClearGroupAutocomplete(widgets.Input):
    """
    Виджет отображающий список групп с автодополнением
    """

    def render(self, name, value, attrs=None):
        final_attrs = self.build_attrs(attrs, type=self.input_type, name=name)
        attr_class = [final_attrs.get('class', ''), 'js-autocomplete_groups']
        final_attrs['class'] = ' '.join(attr_class)
        result = '''
<script type="text/javascript" src="//center.yandex-team.ru/media/js/_js-autocomplete_staff.js"></script>
        '''
        return mark_safe(result + super(ClearGroupAutocomplete, self).render(name, value, final_attrs))


class ClearServiceAutocomplete(widgets.Input):
    """
    Виджет отображающий список сервисов с автодополнением
    """

    def render(self, name, value, attrs=None):
        final_attrs = self.build_attrs(attrs, type=self.input_type, name=name)
        attr_class = [final_attrs.get('class', ''), 'js-autocomplete_services']
        final_attrs['class'] = ' '.join(attr_class)
        return mark_safe(super(ClearServiceAutocomplete, self).render(name, value, final_attrs))


class ClearStaffAutocompleteMultiple(widgets.Textarea):
    """
    Виджет отображающий список персонала с автодополнением
    """

    def __init__(self, multiple=False, attrs=None):
        self.multiple = multiple
        if attrs is None:
            attrs = {}
        attrs.update({'rows': 3})
        super(ClearStaffAutocompleteMultiple, self).__init__(attrs)

    def render(self, name, value, attrs=None):
        onclick = {}
        if self.multiple:
            onclick.update({'multiple': 'true', 'multipleSeparator': '","'})
        js_autocomplete = {
            # , 'onclick': 'return {"value":"%s"}' % self.display
            'class': 'js-autocomplete_staff b-autocomplete-input',
            'autocomplete': 'off',
            'onclick': 'return {%s}' % (', '.join(['%s: %s' % el for el in iter(onclick.items())]),),
        }
        if 'class' in attrs:
            js_autocomplete['class'] = js_autocomplete['class'] + ' ' + attrs['class']
        attrs.update(js_autocomplete)  # = js_autocomplete if attrs is None else dict(attrs, **js_autocomplete)
        result = '''
<script type="text/javascript" src="//center.yandex-team.ru/media/js/_js-autocomplete_groups.js"></script>
        '''
        return mark_safe(result + super(ClearStaffAutocompleteMultiple, self).render(name, value, attrs))


class CheckboxInput(widgets.CheckboxInput):
    pass
