
from random import randrange

from django.conf import settings
from django.forms import CharField, Form

from .base_action import WikiBaseAction


class Forms(WikiBaseAction):
    """
    Экшен {{forms}} вставляет форму с указанным id в iframe.
    Обязательный параметр экшена {id} - id формы.
    """

    def json_for_formatter_view(self, page, user, params):
        form_id = params['id']
        return {
            'path': settings.FORMS_URL_PATTERN.format(id=form_id),
            'name': 'forms-%s-%d' % (form_id, randrange(10000)),
        }

    def form_class_to_validate_params(self):
        class Validator(Form):
            id = CharField(required=True)

        return Validator
