import json

from wiki.actions.classes.base_action_deprecated import OldDjangoWidgetAction
from wiki.org import get_org
from wiki.pages.models import Page


class Mywatches(OldDjangoWidgetAction):
    """
    Экшн {{mywatches}} -- отображет все страницы, на которые подписан текущий пользователь
    """

    @property
    def is_json_rendering(self):
        return self.params.get('render_json') is not None

    @is_json_rendering.setter
    def is_json_rendering(self, value):
        # игнорируем setter, поскольку значение зависит только от GET параметра 'render_json'
        pass

    def render_json(self):
        return json.dumps(self.get_context_data()['pages'])

    def get_context_data(self):
        """
        Return context for template mywatches.html
        """

        pages = (
            Page.active.filter(pagewatch__user=self.request.user.username, org=get_org())
            .order_by('tag')
            .values('tag', 'supertag')[:25]
        )

        context_data = {'pages': [{'tag': page['tag'], 'url': '/' + page['supertag']} for page in pages]}

        return context_data
