

import six
from django import forms


class BooleanFromTextField(forms.BooleanField):
    widget = forms.TextInput

    def to_python(self, value):
        """Returns a Python boolean object."""
        value = self.to_bool(value)
        return super(BooleanFromTextField, self).to_python(value)

    @staticmethod
    def to_bool(value):
        if isinstance(value, six.string_types) and value.lower() in ('false', '0', 'none'):
            return False
        else:
            return bool(value)
