import logging

from django.http import HttpResponseForbidden
from django.views.generic.base import View
from ylog.context import log_context

from wiki.api_core.utils import is_tvm_authentication
from wiki.org import org_ctx
from wiki.utils.request_logging.context import extract_normalized_route

logger = logging.getLogger(__name__)


class ApiView(View):
    """
    Base class for API methods.

    Это какой-то реликт из до-дрфовской эры. Надо бы перевести на дрф.
    Пока что я отрубил
    - passport_or_token_auth -- все равно нигде не был включен
    - token_auth - механизм доступа из подсетей по HTTP_X_YANDEX_DJANGO_API_AUTH заголовку (ват)

    """

    http_method_names = ['get']

    TVM2_AUTH = False

    def dispatch(self, request, *args, **kwargs):
        if self.TVM2_AUTH:
            if not (is_tvm_authentication(request) and request.yauser.is_authenticated()):
                logger.error(
                    '403: TVM ticket auth failed (ip: %s, referer: "%s")',
                    request.META.get('HTTP_X_REAL_IP', request.META['REMOTE_ADDR']),
                    request.META.get('HTTP_REFERER'),
                )
                return HttpResponseForbidden('TVM ticket auth failed')

        request.data = request.GET.copy()
        request.data.update(request.POST)

        route = extract_normalized_route(request)
        endpoint = self.__class__.__name__

        with org_ctx(request.org), log_context(route=route, endpoint=endpoint):
            return super(ApiView, self).dispatch(request, *args, **kwargs)
