"""
Используется во внешних виках, не можем в них ходить в центр.
"""
from json import dumps

from django.db.models import Q
from django.http import Http404, HttpResponse

from wiki.api.views.api_view import ApiView
from wiki.api_core.deprecator import deprecated_api
from wiki.org import org_staff
from wiki.pages.utils import split_wiki_name


class AutocompleteStaffView(ApiView):
    fields = ('id', 'login', 'wiki_name')

    @deprecated_api
    def get(self, request):
        q = request.data.get('q', '')
        limit = request.data.get('limit', 10)
        fields = request.data.get('fields', self.fields)

        if not q:
            raise Http404

        r = list(
            org_staff()
            .filter(Q(login__startswith=q) | Q(wiki_name__startswith=q))
            .values(*fields)
            .order_by(
                'last_name',
                'first_name',
                'login',
            )[:limit]
        )
        for user in r:
            t = split_wiki_name(user['wiki_name']).split(' ')
            user['first_name'] = ' '.join(t[:-1])
            user['last_name'] = t[-1]

        return HttpResponse(dumps(r), content_type='text/javascript')
