import logging

from django.conf import settings
from django.contrib.auth import get_user_model
from django.http import HttpResponse, HttpResponseForbidden
from wiki.intranet.models import Staff

from wiki.api.views.api_view import ApiView
from wiki.files.api import response_to_download_file
from wiki.files.models import File
from wiki.org import get_org, get_user_orgs, org_staff
from wiki.pages.access import has_access
from wiki.pages.dao.page import get_page_by_supertag
from wiki.pages.models import Page, RedirectLoopException
from wiki.utils.supertag import translit

__author__ = 'chapson'

logger = logging.getLogger('django.request')


class Download(ApiView):
    def dispatch(self, request, *args, **kwargs):
        # Авторизируем здесь пользователя по переданному uid, чтобы узнать в какой организации состоит пользователь.
        # TODO Удалить весь метод, когда поддержим tvm и docviewer сможет ходить в АПИ с tvm тикетом.
        if settings.IS_BUSINESS:
            uid = request.GET.get('uid')  # !!! CLOID-UID / Unsupported

            if not uid:
                return HttpResponseForbidden()

            try:
                user = get_user_model().objects.get(staff__uid=uid)  # !!! CLOID-UID / Unsupported
            except get_user_model().DoesNotExist:
                return HttpResponseForbidden()

            # WIKI-10046
            # Пользователь может числиться в организации, откатившейся
            # из Коннекта обратно в ПДД и не удаленной из базы Вики.
            # Поэтому берем организацию с наибольшим id.
            request.org = get_user_orgs(user)[0]

        return super(Download, self).dispatch(request, *args, **kwargs)

    def get(self, request):
        fileid = request.GET.get('fileid', '')
        force_download = str(request.GET.get('download', '0')) == '1'

        logger.info('trying to download ' + fileid)
        separator = fileid.rfind('/')
        supertag, url = fileid[:separator], fileid[separator + 1 :]
        url = translit(url)
        try:
            page = Page.objects.get(supertag=supertag, org=get_org())
            try:
                page = page.redirect_target()
            except RedirectLoopException:
                pass
            file = File.active.get(url=url, page=page)
        except (Page.DoesNotExist, File.DoesNotExist):
            return HttpResponse(status=403)
        # anonymous access
        if request.GET.get('uid', '0') == '0':
            return HttpResponse(status=403)
        logger.info('uid is ' + request.GET.get('uid'))
        try:
            staff = org_staff().get(uid=request.GET['uid'])  # !!! CLOID-UID / Unsupported
        except Staff.DoesNotExist:
            logger.warning('Staff does not exist uid="%s"', request.GET['uid'])
            return HttpResponse(status=403)
        try:
            user = staff.user
        except get_user_model().DoesNotExist:
            return HttpResponse(status=403)
        if not has_access(supertag, user, current_page=get_page_by_supertag(supertag)):
            return HttpResponse(status=403)
        return response_to_download_file(file, force_download)
