
from django.http import HttpResponse, HttpResponseRedirect
from django.utils.decorators import method_decorator
from django.views.decorators.csrf import csrf_protect

from wiki.api.views.api_view import ApiView
from wiki.api_core.deprecator import deprecated_api
from wiki.api_v1.dao.page_catalog import remove_store_last_update_started_at
from wiki.pages.access import is_admin


class ResetPageCatalog(ApiView):
    """
    Сброс каталога страниц
    """

    http_method_names = ('post',)

    @deprecated_api
    @method_decorator(csrf_protect)
    def post(self, request, *args, **kwargs):
        if not is_admin(request.user):
            return HttpResponse(status=403)

        remove_store_last_update_started_at()

        return HttpResponseRedirect(request.META.get('HTTP_REFERER', '/'))
