"""\
    Api ручка "resolve_tilde" по логину пользователя возвращает URL найденной
    страницы личного кластера этого пользователя. Ручка действует перебором и
    возвращает первую найденную страницу из следующих:
        /users/LOGIN
        /WIKINAME
        /LOGIN
    Если ни одной из страниц не найдено, ручка пытается создать страницу
    /users/LOGIN и вернуть уже её URL. Если это не удалось, возвращается пустая
    строка.
"""

from django.contrib.auth import get_user_model
from django.http import Http404, HttpResponse
from django.utils.translation import ugettext_lazy as _

from wiki.api.views.api_view import ApiView
from wiki.api_core.deprecator import deprecated_api
from wiki.org import org_user
from wiki.personalisation.user_cluster import NoPersonalCluster, personal_cluster


class ResolveTilde(ApiView):
    passport_or_token_auth = False

    @deprecated_api
    def get(self, request):
        login = request.GET.get('login')
        url = resolve_tilde(request, login)
        return HttpResponse(url if url else '')


def resolve_tilde(request, after_tilde):
    username, slash, path = after_tilde.partition('/')
    try:
        user = org_user().get(username=username) if username else request.user
    except get_user_model().DoesNotExist:
        raise Http404()

    try:
        redirect_to = '/' + personal_cluster(user).tag
    except NoPersonalCluster:
        # Translators: У вас нет личного кластера.
        raise Http404(_('quick_note:No personal cluster'))

    if path:
        redirect_to += '/' + path.rstrip('/')

    return redirect_to
