
from django.http import HttpResponseRedirect
from django.utils.decorators import method_decorator
from django.views.decorators.csrf import csrf_protect

from wiki.api.views.api_view import ApiView
from wiki.api_core.deprecator import deprecated_api


class GenerateDocs(ApiView):
    """
    Сгенерировать автодокументацию.
    """

    http_method_names = ('post',)

    @deprecated_api
    @method_decorator(csrf_protect)
    def post(self, request, *args, **kwargs):
        # deprecated
        return HttpResponseRedirect(request.META.get('HTTP_REFERER', '/'))
