
from rest_framework.authentication import SessionAuthentication


class SimplifiedSessionAuthentication(SessionAuthentication):
    """
    Аутентификация без CSRF
    """

    def authenticate(self, request):
        # Get the underlying HttpRequest object
        request = request._request
        user = getattr(request, 'user', None)

        # Unauthenticated, CSRF validation not required
        if not user:
            return None

        # CSRF passed with authenticated user
        return user, None
