import functools
import logging

from ylog.context import log_context

logger = logging.getLogger('deprecator')


def deprecated_api(fn):
    @functools.wraps(fn)
    def wrapper(*args, **kwargs):
        with log_context(deprecated_call=1):
            logger.warn('Deprecated API call')
            return fn(*args, **kwargs)

    return wrapper
