
from django.utils.translation import ugettext_lazy as _

from wiki.api_core.errors.rest_api_error import RestApiError


class InvalidDataSentError(RestApiError):
    """
    Запрос от пользователя не проходит валидацию.

    В мапе errors или в message должно быть достаточно информации, чтобы пользователь исправил запрос.
    """

    status_code = RestApiError.STATUSES.HTTP_409_CONFLICT
    error_code = 'CLIENT_SENT_INVALID_DATA'
    debug_message = 'Client sent invalid data'


class ContentTypeMismatch(RestApiError):
    """
    Использован недопустимый тип содержимого в запросе.
    """

    status_code = RestApiError.STATUSES.HTTP_400_BAD_REQUEST
    error_code = 'CONTENT_TYPE_IS_NOT_SUPPORTED'
    debug_message = 'Content-type header is not supported, please read documentation'


class AccessRequestAlreadyProcessed(RestApiError):
    """
    Запрос доступа уже обработан.
    """

    status_code = RestApiError.STATUSES.HTTP_409_CONFLICT
    error_code = 'ACCESS_REQUEST_ALREADY_PROCESSED'
    debug_message = 'The access request is already processed'
    _non_field_messages = [
        # Translators:
        #  ru: Этот запрос доступа уже был обработан
        #  en: This access request has already been processed
        _('This access request has already been processed')
    ]
