
from wiki.api_core.errors.rest_api_error import RestApiError


class BaseWikiFormError(RestApiError):
    status_code = RestApiError.STATUSES.HTTP_500_INTERNAL_SERVER_ERROR


class WikiFormHandlingError(BaseWikiFormError):
    """
    Ошибка при обработке отправленной вики-формы (не валидация отправленных данных)
    """

    error_code = 'WIKIFORM_HANDLING_ERROR'


class WikiFormSourceValidationError(BaseWikiFormError):
    """
    Ошибка валидации вики-формы при сохранении страницы
    """

    error_code = 'INVALID_WIKIFORM_SOURCE'
