
from django.utils.translation import ugettext_lazy as _

from wiki.api_core.errors.rest_api_error import RestApiError


class ReadonlyError(RestApiError):
    """
    Сервис временно не доступен. Нужно отдать управление пользователю,
    показать сообщение об ошибке и сохранить его данные. Пользователь может
    попробовать отправить запрос еще раз.
    """

    status_code = RestApiError.STATUSES.HTTP_503_SERVICE_UNAVAILABLE
    error_code = 'TEMPORARILY_UNAVAILABLE'
    _non_field_messages = [
        # Translators:
        #  ru: Сервис временно недоступен
        #  en: Service is temporarily unavailable
        _('Service is temporarily unavailable')
    ]
    debug_message = 'Wiki is in read only, you should try request later'
