import re


def _replace_width_in_data(data_struct):
    """
    Разбить поле "width" в структуре на "width" и "width_units"
    >>> data = {"width": "200px"}; _replace_width_in_data(data); data == {"width": "200", "width_units": "px"}
    True

    @type data_struct: dict
    @param data_struct: структура, где возможно есть поле "width"
    """
    if 'width' in data_struct:
        stripped, css_unit = _strip_units(data_struct['width'])
        data_struct['width'] = stripped
        data_struct['width_units'] = css_unit


def _strip_units(width_str):
    """
    Разбить строку длинны с единицами измерения на две -
    цифру и строку единиц измерения

    >>> _strip_units('200px')
    ('200', 'px')

    @type width_str: unicode|str
    @rtype: tuple
    @return: (<длинна>, <единицы измерения>)
    """
    unit_mathes = re.search('%|px|pt|em', width_str)

    stripped = width_str[: unit_mathes.start(0)]
    css_unit = width_str[unit_mathes.start(0) : unit_mathes.end(0)]
    return stripped, css_unit


def replace_width_in_grid_structure(structure):
    """
    Разбить поле "width" в json'e ответа ручек грида на "width" и "width_units"

    Удаляет "width" из выдачи структуры грида. Потому что в API width грида не
    имеет значения, а удалять реальные данные рано, старая верстка все еще
    использует этот параметр. Мы его удалим когда будем закрывать старый фронт:
    после закрытия нужно не только удалить width, но и поменять формат данных,
    которые хранятся в E: поля и столбцы;

    @type structure: dict
    """
    if 'width' in structure:
        del structure['width']

    if 'fields' in structure:
        for field_data in structure['fields']:
            _replace_width_in_data(field_data)
