

def pop_non_field_rf_errors(rf_errors, context_key=None):
    """
    Выкусить ошибки rest_framework, которые не относятся к конкретным полям.

    Модифицирует rf_errors.

    @type rf_errors: dict
    @rtype: list
    """
    result = []
    for key in list(rf_errors.keys()):
        if key == 'non_field_errors':
            if context_key:
                result.extend(['{0}: {1}'.format(context_key, message) for message in rf_errors[key]])
            else:
                result.extend(rf_errors[key])
            del rf_errors[key]
        elif isinstance(rf_errors[key], dict):
            result.extend(pop_non_field_rf_errors(rf_errors[key], context_key=key))

    return result
