
import yenv
from django.conf import settings


class DebugRequest(object):

    """
    Ответ с дебаг информацией
    """

    hostname = None
    app_name = None
    app_version = None
    exec_duration = None
    method = None
    page = None
    view = None

    def __init__(self, request, execution_time, page=None):
        if yenv.type in ['testing', 'production']:
            return  # возвращать только в debug-режиме

        if page is None and getattr(request, 'page', None):
            page = request.page

        self.hostname = settings.HOSTNAME
        self.app_name = settings.WIKI_CODE
        self.exec_duration = execution_time
        self.method = request.method
        self.page = page.supertag if page else None
        self.view = getattr(request, 'view_name', None)
