

__all__ = ['StreamPaginator']


class Stream(object):
    qs = None
    last_seen_id = None
    limit = None

    __sequence = None
    _next_last_seen_id = None

    def __init__(self, query_set, limit, start_from):
        self.qs = query_set
        self.limit = limit
        self.last_seen_id = start_from

    def get_qs(self):
        """
        Сформировать query set, чтобы превратить таблицу в некий "поток".
        """
        # +1 нужен, чтобы понять, есть ли в "таблице" еще данные, кроме
        # тех, которые отдадим пользователю.
        query_set = self.qs
        if self.last_seen_id:
            query_set = query_set.filter(id__gt=self.last_seen_id)
        return query_set[: self.limit + 1]

    @property
    def sequence(self):
        if not self.__sequence:
            all_plus_extra_one = list(self.get_qs())
            if len(all_plus_extra_one) > self.limit:
                all_plus_extra_one.pop()
                self._next_last_seen_id = all_plus_extra_one[-1].id
            self.__sequence = all_plus_extra_one
        return self.__sequence

    def __iter__(self):
        return iter(self.sequence)

    @property
    def next_start_id(self):
        self.sequence  # инициализировать.
        return self._next_last_seen_id


class StreamPaginator(object):
    """
    Пагинатор, который возвращает записи в виде потока.

    > paginator = StreamPaginator(qs).

    qs - это некий SELECT в базу, который возвращает много записей,
    поэтому их необходимо разбить на куски по 10 записей.

    Первый запрос выглядит как

    > stream = paginator.paginate(10)
    > for item in stream:
    >   pass
    > print stream.next_start_id

    Если stream.next_start_id не None, то значит в потоке остались еще записи.
    Чтобы запросить их, надо еще раз получить stream:

    > stream = paginator.paginate(10, stream.next_start_id)

    Нельзя запрашивать меньше одной записи. Это не имеет смысла.
    """

    qs = None
    last_seen_id = None
    limit = None

    _sequence = None
    _next_last_seen_id = None

    def __init__(self, query_set):
        self.qs = query_set

    def paginate(self, limit, start_from=None):
        limit = max(int(limit), 1)  # всегда > 0
        return Stream(self.qs, limit, start_from)
