

from rest_framework import renderers as rest_fw_renderers


class WikiBrowsableAPIRenderer(rest_fw_renderers.BrowsableAPIRenderer):
    """
    В html browsable api rest framework пытается для методов PUT и PATCH
    пытается отрендерить html-формы/json-объект, предзаполнив ее данными
    ресурса (в отличие от метода POST, который нужен для создания новой
    сущности — там предзаполнения форм нет).
    Для предзаполнения фреймворк пытается взять данные, которые отдаются из
    метода GET. В нашем случае GET и PUT могут иметь разную структуру (мы не
    очень следуем REST-идеологии) и предзаполнение падает.

    Для этих случаев мы рендерим пустую PUT/PATCH-форму.
    """

    DUMMY_METHOD_SUFFIX = '_DUMMY'

    def get_raw_data_form(self, data, view, method, request):
        data, view, method, request = self.modify_for_rendering(data, view, method, request)
        super_method = super(WikiBrowsableAPIRenderer, self).get_raw_data_form
        return super_method(data, view, method, request)

    def get_rendered_html_form(self, data, view, method, request):
        data, view, method, request = self.modify_for_rendering(data, view, method, request)
        super_method = super(WikiBrowsableAPIRenderer, self).get_rendered_html_form
        return super_method(data, view, method, request)

    def modify_for_rendering(self, data, view, method, request):
        if method.upper() not in ('PUT', 'PATCH'):
            return data, view, method, request

        if method in view.render_blank_form_for_methods:
            method += self.DUMMY_METHOD_SUFFIX
        else:
            # для ресурсов, у которых get и put/patch-данные все же совпадают
            # нужно достать data из debug-обертки.
            if 'data' in data:
                data = data['data']
        return data, view, method, request

    def unwrap_dummy_method(self, method):
        if method.endswith(self.DUMMY_METHOD_SUFFIX):
            method = method[: -len(self.DUMMY_METHOD_SUFFIX)]
        return method

    def show_form_for_method(self, view, method, request, obj):
        method = self.unwrap_dummy_method(method)
        super_method = super(WikiBrowsableAPIRenderer, self).show_form_for_method
        return super_method(view, method, request, obj)
