

from datetime import datetime, timedelta  # noqa

from rest_framework import serializers


class DateTimeTzAwareField(serializers.DateTimeField):
    """
    Рендерит дату-время в виде локального времени, в часовом поясе,
    который пользователь выбрал в Стаффе в формате ISO_8601,
    но если бы у него откусили всю информацию об временной зоне:

    2020-06-23T13:59:21

    """

    def to_representation(self, value):
        """
        @type value: datetime
        @rtype: basestring
        """

        # Раньше тут была логика которая переводила датувремя в "наивную"
        # заранее перевинув ее в часовой пояс пользователя

        # Теперь, так как наивные в DRF все равно получают енфорс зоны пользователя
        # мы просто скажем, что нам нужен вот этот вот странный формат  вывода

        self.format = '%Y-%m-%dT%H:%M:%S'
        return super(DateTimeTzAwareField, self).to_representation(value)
