
from datetime import datetime
from rest_framework import serializers
from django.utils.translation import ugettext_lazy as _


class TimestampField(serializers.IntegerField):
    """
    Timestamp в секундах. Тот же IntegerField, но осуществляет
    дополнительную проверку на нахождение в допустимом интервале timestamp'а.
    """

    default_error_messages = {
        # Translators:
        #  ru: Timestamp должен находиться в допустимом интервале значений
        #  en: Timestamp must be in the valid range of values
        'invalid_timestamp_range': _('Invalid timestamp range')
    }

    def to_internal_value(self, data):
        value = super(TimestampField, self).to_internal_value(data)
        if value:
            try:
                datetime.fromtimestamp(value)
            except ValueError:
                self.fail('invalid_timestamp_range')
        return value
