from rest_framework import serializers

from wiki.pages.models.page import Page


class PageTypeSerializer(serializers.Field):
    def to_representation(self, value):
        return Page.TYPES[value]


class PageRedirectSerializer(serializers.Serializer):
    redirect_to_tag = serializers.CharField()
    page_type = serializers.SerializerMethodField()

    def get_page_type(self, obj):
        """
        @param obj: Dict, object that is to be serialized
        @return:
        """
        return Page.TYPES[obj.get('page_type', Page.TYPES.PAGE)]
