
from rest_framework import serializers

from wiki.api_core.serializers.users import RequestUserSerializer


class DebugRequestSerializer(serializers.Serializer):
    """
    Запрос с объекте ответа с дебаг информацией
    """

    hostname = serializers.CharField()
    app_name = serializers.CharField()
    app_version = serializers.CharField()
    exec_duration = serializers.IntegerField()
    method = serializers.CharField()
    page = serializers.CharField()  # тэг запрошенной страницы
    view = serializers.CharField()  # отработавшая вьюха


class DebugResponseSerializer(serializers.Serializer):
    """
    Ответ с дебаг информацией
    """

    debug = DebugRequestSerializer()
    data = serializers.ReadOnlyField()
    user = RequestUserSerializer()


class ErrorResponseSerializer(serializers.Serializer):
    debug = DebugRequestSerializer()
    error = serializers.ReadOnlyField()
    user = RequestUserSerializer()
