

from rest_framework.serializers import ValidationError

from wiki.org import get_org
from wiki.utils.supertag import tag_to_supertag


def validate_page_does_not_exist(tag):
    from wiki.pages.models import Page

    if Page.active.filter(supertag=tag_to_supertag(tag), org=get_org()).exists():
        raise ValidationError('Page `%s` exists' % tag)
