

def simplify_grid_row_errors(errors, grid=None):
    """
    Фронтэнду неудобно маппить ошибки валидации полей запроса на ячейки грида.

    Поэтому ошибки вида {"field": "This field is required"}
    превращаем в ["field_title: This field is required"].

    @type errors: dict
    @rtype: list
    """
    error_messages = []
    for key, messages in errors.items():
        if isinstance(messages, str):
            messages = [messages]
        title = (grid.column_by_name(key) or {}).get('title', key) if grid else key
        for message in messages:
            error_messages.append('{title}: {message}'.format(title=title, message=message))

    return error_messages


def yield_key_value_string_errors(errors):
    """
    Достать пары "строка" - "строка" из словаря

    из {"changes":["{'added_column': {'type': [u'This field is required.']}}"]}
    вернуть ("type", "This field is required.")

    @type errors: dict
    @rtype: tuple
    """
    for field_title, messages in errors.items():
        if isinstance(messages, list):
            for message in messages:
                if isinstance(message, dict):
                    for result in yield_key_value_string_errors(message):
                        yield result
                else:
                    yield field_title, str(message)
        else:
            for result in yield_key_value_string_errors(messages):
                yield result
