from django.conf import settings
from rest_framework import serializers

from wiki.api_core.serializers import DateTimeTzAwareField
from wiki.api_frontend.serializers.base import NamedIdentifiableSerializer, StringNamedIdentifiableSerializer
from wiki.api_frontend.serializers.users import UserSerializer


class AccessRequestSerializer(serializers.Serializer):
    status = serializers.ChoiceField(choices=('pending', 'processed', 'obsolete'))


class PendingAccessRequestDeniableSerializer(AccessRequestSerializer):
    may_allow = serializers.BooleanField()
    applicant = UserSerializer()
    reason = serializers.CharField()
    requested_at = DateTimeTzAwareField()


class PendingAccessRequestAllowableSerializer(PendingAccessRequestDeniableSerializer):
    if settings.IS_BUSINESS:
        applicant_services = StringNamedIdentifiableSerializer(many=True)
        applicant_departments = StringNamedIdentifiableSerializer(many=True)
    else:
        applicant_services = NamedIdentifiableSerializer(many=True)
        applicant_departments = NamedIdentifiableSerializer(many=True)


class ProcessedAccessRequestSerializer(AccessRequestSerializer):
    granted = serializers.BooleanField()
    verdict_by = UserSerializer()
    verdict_reason = serializers.CharField()
