
from rest_framework import serializers

from wiki.api_core.serializers import UserSerializer
from wiki.api_frontend.serializers.user_identity import UserIdentityListField


class AuthorsSerializer(serializers.Serializer):
    authors = UserSerializer(many=True)


class ChangeAuthorsSerializer(serializers.Serializer):
    authors = UserIdentityListField()
    replace_authors = UserIdentityListField(required=False)
    with_subpages = serializers.BooleanField(required=False, default=False)

    default_error_messages = {
        'replace_authors_without_subpages': '`replace_authors` option make sense only with option `with_subpages=True`',
        'author_required': 'At least one author is required',
    }

    def validate(self, attrs):
        replace_authors = attrs.get('replace_authors')
        if replace_authors and not attrs['with_subpages']:
            self.fail('replace_authors_without_subpages')

        authors = attrs.get('authors')
        if not authors:
            self.fail('author_required')

        return attrs
