"""
Сериализаторы диффов
"""
from rest_framework import serializers


class DiffField(serializers.Serializer):
    def to_representation(self, instance):
        """
        obj[field_name] - объект в формате, в котором его отдает wiki.utils.diff.DifflibDiff(return_type='chunks')
        """

        result = []

        for line in instance:
            line_operations = set(operation for operation, substring in line)
            if line_operations == set(['=']):
                changes = 'nothing'
            elif '+' in line_operations and '-' not in line_operations:
                changes = 'additions'
            elif '-' in line_operations and '+' not in line_operations:
                changes = 'deletions'
            else:
                changes = 'both'

            result.append(
                {
                    'changes': changes,
                    'chunks': [
                        {
                            'action': 'added' if o == '+' else 'deleted' if o == '-' else 'not_changed',
                            'substring': s,
                        }
                        for o, s in line
                    ],
                }
            )

        return result


class NotEditedFieldSerializer(serializers.Serializer):
    field_id = serializers.CharField()
    raw_content = serializers.CharField()


class NotEditedRowSerializer(serializers.Serializer):
    row_id = serializers.CharField()
    fields = NotEditedFieldSerializer(many=True)


class EditedFieldSerializer(serializers.Serializer):
    field_id = serializers.CharField()
    diff_raw_content = DiffField()


class EditedRowSerializer(serializers.Serializer):
    row_id = serializers.CharField()
    fields = EditedFieldSerializer(many=True)


class PageDiffSerializer(serializers.Serializer):
    def __init__(self, diff=None, *args, **kwargs):
        super(PageDiffSerializer, self).__init__({'diff': diff}, *args, **kwargs)

    diff = DiffField()


class GridDiffSerializer(serializers.Serializer):
    diff = serializers.DictField()
    titles = serializers.DictField()
